% ccdb_test: Perform 3-fold cross validation on different versions of
%            the proposed method on the linear color checker database.
%
% [ae ei] = ccdb_test(in_dir, img_ext, out_dir, db_file)
%
%    in_dir:     Path to directory containing data files
%                (eg. '/data/shi')
%    img_ext:    Extension of the image files (eg. 'png')
%    out_dir:    Directory to save all the precomputed and training
%                data. Make sure this directory is on a device with
%                enough space--- for the color checker database,
%                the precomputed file for each image will be around
%                70MB. 
%    db_file:    .mat file containing image names, ground truth,
%                 mask data, category information. See the file
%                 cc_gt.mat provided with the source code as example.
%
%  Output:
%    ae:          Nx3 cell, containing angular errors of ML
%                 estimate, general prior and category-wise prior
%                 for each image.
%    ei:          Nx3x3 cell, where each ei(:,:,i) contains the
%                 estimated illuminants for the different
%                 strategies.
clear 
close all
  curentdir='H:\CIM\Potential Research\spatio-spectral modeling\chz_cc2011\Raw Database_ds';

  img_ext='png';
  out_dir=[curentdir,'/out_dir_author_labtop'];
%   out_dir=[curentdir,'/out_dir_origin'];
  db_file='cc_gt_ds.mat';

  in_dir=[curentdir];
  
  %% Main

  DB = open(db_file);
  
  N = length(DB.all_image_names);
  ae = zeros([N 3]);
  ei = zeros([N 3 3]);
  exe_t = zeros([N 3]);
  
  % Do precomputation
  pc_names = cell(N,1);
  for i = 1:N
    tic
    pc_names{i} = [out_dir '/' DB.all_image_names{i} '.pc.mat'];
    precompute([in_dir '/' DB.all_image_names{i} '.' img_ext], ...
	pc_names{i}, DB.mask(i,:));
    precomputation_time(i)=toc;
    fprintf(' Precomputing for %s  exe_t: %4.2f\n',DB.all_image_names{i},precomputation_time(i));
  end;
  
  % Start testing
  svbase = [out_dir '/train'];
  truel = DB.groundtruth_illuminants;
  truel = truel ./ repmat(sqrt(sum(truel.^2,2)),[1 3]);

  
  for fold=1:3
      
      % ML
      tic
      train3fold(@train,pc_names,truel,svbase,fold)
      train_ML(fold)=toc
      [ae1 ei1 exe_t1] = test3fold(@estimate,out_dir,db_file,svbase,fold);
      ae(:,1) =ae(:,1)+ae1; ei(:,:,1) = ei(:,:,1)+ei1;exe_t(:,1) =exe_t(:,1)+exe_t1;
%       save precomputation_result
      
  end
        
  [mn1 md1 wst1]=report_errors(ae(:,1),DB.clabel,DB.categ_names);
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,1)));
  
for fold=1:3
      
      % General Prior
      tic
      train3fold(@trainPrior,pc_names,truel,svbase,fold)  
      train_GP(fold)=toc
      [ae2 ei2 exe_t2] = test3fold(@estimatePrior,out_dir,db_file,svbase,fold);
      ae(:,2) =ae(:,2)+ ae2; ei(:,:,2) = ei(:,:,2)+ ei2; exe_t(:,2) =exe_t(:,2)+exe_t2;
%       save precomputation_result
end

  [mn2 md2 wst2]=report_errors(ae(:,2),DB.clabel,DB.categ_names);
  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,2)));

for fold=1:3
      
      % Prior WL 
      tic
      train3fold(@trainPriorWL,pc_names,truel,svbase,fold,DB.clabel)  
      train_WL(fold)=toc
      [ae3 ei3 exe_t3] = test3fold(@estimatePriorWL,out_dir,db_file,svbase,fold,DB.clabel);
      ae(:,3) =ae(:,3)+ ae3; ei(:,:,3) = ei(:,:,3)+ ei3; exe_t(:,3) =exe_t(:,3)+exe_t3;
%       save precomputation_result
end

  fprintf(' Average Execution Time: %d\n',mean(exe_t(:,3)));
  [mn3 md3 wst3]=report_errors(ae(:,3),DB.clabel,DB.categ_names);

save('test_ds_labtop','ae','ei','exe_t','precomputation_time','train_GP','train_ML','train_WL') 
  
  
  
  
  

      

